/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.Utils;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class CriticalSpeedModifier
extends Modifier
implements MeleeHitModifierHook,
AttributesModifierHook,
InventoryTickModifierHook,
ModifierRemovalHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "critical_speed");

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isCritical()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(7, ((TinkerEffect)Utils.criticalspeedEffect.get()).getLevel(attacker) + 1);
            ((TinkerEffect)Utils.criticalspeedEffect.get()).apply(attacker, 100, effectLevel, false);
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putFloat(this.KEY, (float)(effectLevel + 1));
        }
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && holder.m_21211_() != stack && isSelected) {
            ModDataNBT persistentData = tool.getPersistentData();
            if (((TinkerEffect)Utils.criticalspeedEffect.get()).getLevel(holder) == -1) {
                persistentData.remove(this.KEY);
            }
        }
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.ATTRIBUTES, ModifierHooks.MELEE_HIT, ModifierHooks.INVENTORY_TICK, ModifierHooks.REMOVE});
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)modifier.getId());
        return null;
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        double boost;
        if (slot == EquipmentSlot.MAINHAND && (boost = (double)(tool.getPersistentData().getFloat(this.KEY) * (float)modifier.getLevel() / 8.0f)) != 0.0) {
            consumer.accept(Attributes.f_22283_, new AttributeModifier(UUID.fromString("d140d20c-28b3-4b0f-8720-b3a1416942b5"), Attributes.f_22283_.m_22087_(), boost, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }
}

